/*** 1.   ũƮ ***/

SELECT rownum AS seq, NEWID() AS main_code
	, DATEADD(MINUTE, rownum, '2020-01-01 00:00:00.000') AS date
INTO TB_FMain02
FROM (SELECT ROW_NUMBER() OVER (ORDER BY A.number) AS rownum, A.number
	 FROM master..spt_values A 
	 JOIN master..spt_values B
	 ON A.type = 'P' AND B.type = 'P' AND A.number <= 1000 AND B.number <= 1000
) A

SELECT main_code AS sub_code
	, CAST(seq%5326 AS INT) AS value 
INTO TB_FSub02 
FROM TB_FMain02

SELECT main_code AS code 
INTO TB_FCode02 
FROM TB_FMain02

CREATE CLUSTERED INDEX CIDX_FMain02 ON TB_FMain02(date)
CREATE INDEX NIDX01_FSub02 ON TB_FSub02(sub_code)
GO

/*** Լ  ***/
CREATE FUNCTION [dbo].[FN_RTCode]
(@a UNIQUEIDENTIFIER)
RETURNS UNIQUEIDENTIFIER
AS
BEGIN
	DECLARE @b UNIQUEIDENTIFIER
		SELECT @b = sub_code 
		FROM TB_FSub02 A INNER JOIN TB_FCode02 B
		ON A.sub_code = B.code
		WHERE A.sub_code = @a
	RETURN @b
END
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT *, [dbo].[FN_RTCode](Main_Code) AS f
FROM TB_FMain02 A 
WHERE A.date BETWEEN '2020-01-30 00:00:00.000' AND '2020-01-30 05:59:59.000'
GO


/*** 6. [TO-BE]   ***/

--ε  
CREATE INDEX NIDX01_FCode02 ON TB_FCode02(code)
GO

--SQL 
SELECT *, [dbo].[FN_RTCode](Main_Code) AS f
FROM TB_FMain02 A 
WHERE A.date BETWEEN '2020-01-30 00:00:00.000' AND '2020-01-30 05:59:59.000'
GO